<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function reponses()
    {
        return $this->hasMany('App\Models\Reponse', 'add_by');
    }

    public function intents()
    {
        return $this->hasMany('App\Models\Intent', 'add_by');
    }

    public function questions()
    {
        return $this->hasMany('App\Models\Question', 'add_by');
    }

    public function appels()
    {
        return $this->hasMany('App\Models\Appel', 'id_user');
    }

}